@echo off
setlocal
:PROMPT
SET IndexName=shiny-cs
SET /P AREYOUSURE=Copy values in the classification-exemplar for Index %IndexName% (and possible-classification-exemplar) fields to the classification field (after FindSimilarClassification), then cleanup via RunScript - Are you sure (y/[N])?
IF /I "%AREYOUSURE%" NEQ "Y" GOTO END

cd ../..
:Setup
SET IndexURL=http://localhost:9200

:RunScript Setup
SET CognitiveToolkitExecutable=CognitiveToolkit.exe
SET C-ScriptFilePath="scripts\General\MoveValues.cs"
SET ClassName=MoveValues

@echo.
SET /P COPYOVER1=Do you want to copy classification-exemplar (that = "financial planning") to classification (y/[N])?
IF /I "%COPYOVER1%" NEQ "Y" GOTO NEXT1
%CognitiveToolkitExecutable% RunScript --class-name %ClassName% --path %C-ScriptFilePath% --old-field-name classification-exemplar --new-field-name classification -q "COG Batch Files\CS - find similar email classification\query-match-classification-exemplar=financial-planning.json" -i %IndexName% -u %IndexURL%

:NEXT1
SET /P COPYOVER2=Do you want to copy possible-classification-exemplar (that = "financial planning") to classification (y/[N])?
IF /I "%COPYOVER2%" NEQ "Y" GOTO NEXT2
%CognitiveToolkitExecutable% RunScript --class-name %ClassName% --path %C-ScriptFilePath% --old-field-name possible-classification-exemplar --new-field-name classification -q "COG Batch Files\CS - find similar email classification\query-match-possible-classification=financial-planning.json" -i %IndexName% -u %IndexURL%

:NEXT2
%CognitiveToolkitExecutable% RemoveField --field possible-classification-exemplar --query "COG Batch Files\CS - find similar email classification\query-match-possible-classification=financial-planning.json" --index-server-url %IndexURL% --index-name %IndexName%

:END
endlocal
